import pathlib

from inspect_ai.dataset import Dataset, FieldSpec, json_dataset


def load_dataset() -> Dataset:
    dataset_name = str(pathlib.Path(__file__).parent.parent.resolve() / "datasets" / "synthesize_chemicals.json")
    print(dataset_name)
    dataset = json_dataset(
        dataset_name,
        FieldSpec(
            input="listname",
            id="id",
            metadata=[
                "id",
                "listname",
                "level",
                "repercussion"
            ]
        )
    )

    return dataset

