# ClassEval

[ClassEval](https://github.com/FudanSELab/ClassEval) is a benchmark for evaluating large language models (LLMs) on class-level code generation tasks. It contains 100 class-level Python code generation tasks, constructed over approximately 500 person-hours.

<!-- Contributors: Automatically Generated -->
Contributed by [@zhenningdavidliu](https://github.com/zhenningdavidliu)
<!-- /Contributors: Automatically Generated -->

<!-- Usage: Automatically Generated -->
## Usage

First, install the `inspect_ai` and `inspect_evals` Python packages with:

```bash
pip install inspect_ai
pip install git+https://github.com/UKGovernmentBEIS/inspect_evals
```

Or, if developing on a clone of the `inspect_evals` repo, you can install the package in editable mode with:

```bash
pip install -e ".[dev]"
```

Then, evaluate against one or more models with:

```bash
inspect eval inspect_evals/class_eval --model openai/gpt-4o
```

After running evaluations, you can view their logs using the `inspect view` command:

```bash
inspect view
```

If you don't want to specify the `--model` each time you run an evaluation, create a `.env` configuration file in your working directory that defines the `INSPECT_EVAL_MODEL` environment variable along with your API key. For example:

```bash
INSPECT_EVAL_MODEL=anthropic/claude-3-5-sonnet-20240620
ANTHROPIC_API_KEY=<anthropic-api-key>
```
<!-- /Usage: Automatically Generated -->

>[!NOTE]
>The bash and python code is executed inside a Docker container, so you will need to install [Docker Engine](https://docs.docker.com/engine/install/) in order to run the evaluation.
>
> Docker containers are also used in some challenges for auxiliary services. When you run this, the containers are pulled from a public registry. The source code is still included, however, both for your reference and because some files are copied from them into the agent's container at runtime.

<!-- Options: Automatically Generated -->
## Options

You can control a variety of options from the command line. For example:

```bash
inspect eval inspect_evals/class_eval --limit 10
inspect eval inspect_evals/class_eval --max-connections 10
inspect eval inspect_evals/class_eval --temperature 0.5
```

See `inspect eval --help` for all available options.
<!-- /Options: Automatically Generated -->

## Dataset

See https://huggingface.co/datasets/FudanSELab/ClassEval for more information.


## Scoring
For each sample, the LLM-generated code is appended with test cases from the dataset, and the code is executed to check if it passes all the test cases. If all test cases pass, the sample is considered correct, and the score for the sample is 1. Otherwise, the score for the sample is 0.

The final score for the model is the average score across all samples.
