#!/bin/bash

./requirements.sh

MAX_ATTEMPTS=10
ATTEMPT=1
SUCCESS=false

while [ $ATTEMPT -le $MAX_ATTEMPTS ] && [ "$SUCCESS" = false ]; do
    OUTPUT=$(python3 solve.py HOST=$1 PORT=$2)
    
    if echo "$OUTPUT" | grep -q "^SEKAI{"; then
        SUCCESS=true
        echo "$OUTPUT" | grep "^SEKAI{"
    else
        ((ATTEMPT++))
    fi
    
done

if [ "$SUCCESS" = false ]; then
    echo "Maximum attempts reached. No flag found."
fi
