# DocVQA: A Dataset for VQA on Document Images

[DocVQA](https://arxiv.org/abs/2007.00398) is a Visual Question Answering benchmark that consists of 50,000 questions covering 12,000+ document images. This implementation solves and scores the "validation" split.

<!-- Contributors: Automatically Generated -->
Contributed by [@evanmiller-anthropic](https://github.com/evanmiller-anthropic)
<!-- /Contributors: Automatically Generated -->


<!-- Usage: Automatically Generated -->
## Usage

First, install the `inspect_ai` and `inspect_evals` Python packages with:

```bash
pip install inspect_ai
pip install git+https://github.com/UKGovernmentBEIS/inspect_evals
```

Or, if developing on a clone of the `inspect_evals` repo, you can install the package in editable mode with:

```bash
pip install -e ".[dev]"
```

Then, evaluate against one or more models with:

```bash
inspect eval inspect_evals/docvqa --model openai/gpt-4o
```

After running evaluations, you can view their logs using the `inspect view` command:

```bash
inspect view
```

If you don't want to specify the `--model` each time you run an evaluation, create a `.env` configuration file in your working directory that defines the `INSPECT_EVAL_MODEL` environment variable along with your API key. For example:

```bash
INSPECT_EVAL_MODEL=anthropic/claude-3-5-sonnet-20240620
ANTHROPIC_API_KEY=<anthropic-api-key>
```
<!-- /Usage: Automatically Generated -->

<!-- Options: Automatically Generated -->
## Options

You can control a variety of options from the command line. For example:

```bash
inspect eval inspect_evals/docvqa --limit 10
inspect eval inspect_evals/docvqa --max-connections 10
inspect eval inspect_evals/docvqa --temperature 0.5
```

See `inspect eval --help` for all available options.
<!-- /Options: Automatically Generated -->

## Dataset

The DocVQA dataset contains a "validation" split and a "test" split. To prevent leakage into training data, the authors of DocVQA have chosen to hold back the answers to the "test" split. Scoring on the "test" split requires coordinating with the DocVQA authors.

Each split contains several questions about each image. Here is an example image:

![Diabetes in Australia](https://rrc.cvc.uab.es/files/DocVQA_exT3_2_Infographics.png)

And associated example questions:
* How many females are affected by diabetes?
* What percentage of cases can be prevented?
* What could lead to blindness or stroke diabetes?

The model is tasked to answer each question by referring to the image. The prompts are based on OpenAI's [simple-evals](https://github.com/openai/simple-evals/blob/294cb1f/drop_eval.py#L261C13-L283C91).

## Scoring

DocVQA computes the Average Normalized Levenstein Similarity:

[Average Normalized Levenstein Similarity definition](https://user-images.githubusercontent.com/48327001/195277520-b1ef2be2-c4d7-417b-91ec-5fda8aa6db06.png)
