# GAIA

This is an Inspect AI implementation of [the GAIA (General AI Assistants)](https://arxiv.org/abs/2311.12983) benchmark, consisting of 450 questions testing tool use on realistic assistant tasks (mostly web browsing).


<!-- Contributors: Automatically Generated -->
Contributed by [@max-kaufmann](https://github.com/max-kaufmann)
<!-- /Contributors: Automatically Generated -->


<!-- Usage: Automatically Generated -->
## Usage

First, install the `inspect_ai` and `inspect_evals` Python packages with:

```bash
pip install inspect_ai
pip install git+https://github.com/UKGovernmentBEIS/inspect_evals
```

Or, if developing on a clone of the `inspect_evals` repo, you can install the package in editable mode with:

```bash
pip install -e ".[dev]"
```

Then, evaluate against one or more models with:

```bash
inspect eval inspect_evals/gaia --model openai/gpt-4o
inspect eval inspect_evals/gaia_level1 --model openai/gpt-4o
inspect eval inspect_evals/gaia_level2 --model openai/gpt-4o
inspect eval inspect_evals/gaia_level3 --model openai/gpt-4o
```

After running evaluations, you can view their logs using the `inspect view` command:

```bash
inspect view
```

If you don't want to specify the `--model` each time you run an evaluation, create a `.env` configuration file in your working directory that defines the `INSPECT_EVAL_MODEL` environment variable along with your API key. For example:

```bash
INSPECT_EVAL_MODEL=anthropic/claude-3-5-sonnet-20240620
ANTHROPIC_API_KEY=<anthropic-api-key>
```
<!-- /Usage: Automatically Generated -->

<!-- Options: Automatically Generated -->
## Options

You can control a variety of options from the command line. For example:

```bash
inspect eval inspect_evals/gaia --limit 10
inspect eval inspect_evals/gaia_level1 --max-connections 10
inspect eval inspect_evals/gaia_level2 --temperature 0.5
```

See `inspect eval --help` for all available options.
<!-- /Options: Automatically Generated -->


> [!NOTE]
> The GAIA task uses [tool calling](https://inspect.ai-safety-institute.org.uk/tools.html) to enable the model to execute web_browser and bash commands. Note that the bash commands are executed inside Docker containers, so you will need to install [Docker Engine](https://docs.docker.com/engine/install/) in order to run the evaluation.
>
> Upon running the GAIA task, it will attempt to download the dataset from the HuggingFace hub. For this to work, you will need to gain access to the dataset (by filling out a form on [the GAIA huggingface repository](https://huggingface.co/datasets/gaia-benchmark/GAIA)), and also [create and set an access token](https://huggingface.co/docs/hub/en/security-tokens). You will need to define the `HF_TOKEN` environment variable to access the dataset:
>
>```
>HF_TOKEN=<hf-token>
>```

## Dataset

The GAIA dataset contains 450 questions testing tool use on realistic assistant tasks (mostly web browsing). For example:

> A paper about AI regulation that was originally submitted to arXiv.org in June 2022 shows a figure with three axes, where each axis has a label word at both ends. Which of these words is used to describe a type of society in a Physics and Society article submitted to arXiv.org on August 11, 2016?

## Scoring

A simple mean is calculated over the datapoints.

## Development

If you want to develop a solver for the GAIA task, import the `@task` from the `gaia` module and pass your own solver to it. For example:

```python
from inspect_ai import eval
from inspect_ai.solver import use_tools, generate, system_message, basic_agent
from inspect_ai.tool import bash, web_search

from inspect_evals.gaia import gaia

agent = basic_agent(tools=[bash()])
task = gaia(solver=agent)

eval(task, model="openai/gpt-4o")
```

See the documentation on the Inspect [Agents API](https://inspect.ai-safety-institute.org.uk/agents-api.html) for additional information on developing agents.

### Test Split

You can evaluate against the "test" split with:

```python
agent = basic_agent(tools=[bash()])
task = gaia(plan=agent, split="test")

eval(task, model="openai/gpt-4o")
```

Note that the GAIA "test" split does not come with any solutions so is not scored (rather, solutions are uploaded to the online leaderboard).
