# Based on original livebench, which processes batch results
# https://github.com/LiveBench/LiveBench/blob/main/livebench/process_results/instruction_following/utils.py
from typing import Any, Dict, List, Tuple


def instruction_following_process_results(
    question_obj: Dict[str, Any], prompt_text: str, llm_answer: str
) -> float:
    from livebench.process_results.instruction_following.utils import (  # type: ignore
        score_results,
    )

    llm_answer = llm_answer.strip()

    follow_all_instructions, follow_instruction_list = instruction_evaluator(
        question_obj, prompt_text, llm_answer
    )

    score: float = score_results(follow_all_instructions, follow_instruction_list)
    return score


def instruction_evaluator(
    question_obj: Dict[str, Any], prompt_text: str, llm_answer: str
) -> Tuple[bool, List[bool]]:
    # https://github.com/LiveBench/LiveBench/blob/main/livebench/if_runner/instruction_following_eval/evaluation_main.py
    from livebench.if_runner.instruction_following_eval.evaluation_main import (  # type: ignore
        InputExample,
        OutputExample,
        test_instruction_following_strict,
    )

    input = InputExample(
        key=question_obj["question_id"],
        instruction_id_list=question_obj["instruction_id_list"],
        prompt=prompt_text,
        kwargs=question_obj["kwargs"],
    )
    prompt_to_response = {}
    prompt_to_response[input.prompt] = llm_answer
    result: OutputExample = test_instruction_following_strict(input, prompt_to_response)
    follow_all_instructions = result.follow_all_instructions
    follow_instruction_list = result.follow_instruction_list

    return follow_all_instructions, follow_instruction_list
