"""A dummy agent which copies the `sample_submission.csv` from the workspace/data directory and uses that as its `submission.csv`."""

import getpass
import os
import shutil
import sys
from pathlib import Path

# Get the current user's username
username = getpass.getuser()

# Check if the current user ID is 0 (root user ID on Unix-like systems)
if os.getuid() == 0:
    print(f"You are running this script as root. Your username is '{username}'.")
else:
    print(f"You do not have root access. Your username is {username}.")

print("The script is being run with the following python interpreter:")
print(sys.executable)

print("Copying sample submission...")

shutil.copy(
    Path("data") / "sample_submission.csv",
    Path("submission") / "submission.csv",
)

print(f"Sample submission copied to {Path('submission') / 'submission.csv'}.")
