def create_question_prompt(context: str = "", question: str = "") -> str:
    """
    Creates a full prompt by combining a given context and question into a formatted string.

    Args:
        context (str): The context text including the needle. Default is an empty string.
        question (str): The question related to the needle. Default is an empty string.

    Returns:
        str: A formatted string that combines the context text (with needle) and question in a structured format.
    """
    return f"""
    Context: {context}

    Question: {question}

    Don't give information outside the context or repeat your findings.
    """


# Generate question prompt with empty context and question for token calculations
QUESTION_PROMPT = create_question_prompt()

# Define the main prompt format
MAIN_PROMPT = """
Please read the context and then answer the question:
{prompt}
"""
