from pathlib import Path

from .controller import OSWorldController


class OSWorldDesktopEnv:
    def __init__(self) -> None:
        self._cache_path = Path(__file__).resolve().parent.parent / "cache"
        self._cache_path.mkdir(parents=True, exist_ok=True)
        self._controller = OSWorldController()

    @property
    def cache_dir(self) -> str:
        return str(self._cache_path)

    @property
    def controller(self) -> OSWorldController:
        return self._controller

    @property
    def vm_platform(self) -> str:
        process_result = self.controller.execute_python_command(
            "import platform; print(platform.system())"
        )
        assert process_result.status == "success", "platform.system() must succeed"
        return process_result.output.strip()
