import logging
import logging.config


class InfoFilter(logging.Filter):
    def filter(self, record: logging.LogRecord) -> bool:
        return record.levelno < logging.WARNING


LOGGING_CONFIG = {
    "version": 1,
    "disable_existing_loggers": False,
    "formatters": {
        "default": {
            "format": "%(name)s(pid=%(process)d) - %(levelname)s - %(message)s",
        },
    },
    "handlers": {
        "stderr": {
            "level": "WARNING",
            "formatter": "default",
            "class": "logging.FileHandler",
            "filename": "cli.err",
            "mode": "w",
        },
        "stdout": {
            "level": "DEBUG",
            "filters": ["info_filter"],
            "formatter": "default",
            "class": "logging.FileHandler",
            "filename": "cli.log",
            "mode": "w",
        },
        "process_1_stdout": {
            "level": "DEBUG",
            "filters": ["info_filter"],
            "formatter": "default",
            "class": "logging.StreamHandler",
            "stream": open("/proc/1/fd/1", "w"),
        },
        "process_1_stderr": {
            "level": "WARNING",
            "formatter": "default",
            "class": "logging.StreamHandler",
            "stream": open("/proc/1/fd/2", "w"),
        },
    },
    "filters": {
        "info_filter": {
            "()": InfoFilter,
        },
    },
    "loggers": {
        "osworld_cli": {
            "handlers": ["process_1_stdout", "process_1_stderr", "stdout", "stderr"],
            "level": "DEBUG",
            "propagate": False,
        },
    },
}

# Apply the logging configuration
logging.config.dictConfig(LOGGING_CONFIG)

# Get the logger
logger = logging.getLogger("osworld_cli")
