import os
import subprocess
from pathlib import Path


# returns True if the repo was updated
def get_sparse_repo(remote_repo_url: str, repo_path: Path, sparse_root: str) -> bool:
    if not os.path.exists(repo_path):
        repo_path.mkdir(parents=True, exist_ok=True)
        subprocess.run(
            [
                "git",
                "clone",
                "--depth",
                "1",
                "--filter=blob:none",
                "--sparse",
                remote_repo_url,
                repo_path,
            ],
            check=True,
        )
        subprocess.run(
            [
                "git",
                "sparse-checkout",
                "set",
                "--no-cone",
                sparse_root,
            ],
            cwd=repo_path,
            check=True,
        )
        return True
    else:
        result = subprocess.run(
            [
                "git",
                "pull",
            ],
            cwd=repo_path,
            check=True,
            capture_output=True,
        )
        return not result.stdout.decode("utf-8").startswith("Already up to date")
