# PIQA

[PIQA](https://arxiv.org/pdf/1911.11641) is a benchmark to measure the model's physical commonsense reasoning.

<!-- Contributors: Automatically Generated -->
Contributed by [@seddy-aisi](https://github.com/seddy-aisi)
<!-- /Contributors: Automatically Generated -->

<!-- Usage: Automatically Generated -->
## Usage

First, install the `inspect_ai` and `inspect_evals` Python packages with:

```bash
pip install inspect_ai
pip install git+https://github.com/UKGovernmentBEIS/inspect_evals
```

Or, if developing on a clone of the `inspect_evals` repo, you can install the package in editable mode with:

```bash
pip install -e ".[dev]"
```

Then, evaluate against one or more models with:

```bash
inspect eval inspect_evals/piqa --model openai/gpt-4o
```

After running evaluations, you can view their logs using the `inspect view` command:

```bash
inspect view
```

If you don't want to specify the `--model` each time you run an evaluation, create a `.env` configuration file in your working directory that defines the `INSPECT_EVAL_MODEL` environment variable along with your API key. For example:

```bash
INSPECT_EVAL_MODEL=anthropic/claude-3-5-sonnet-20240620
ANTHROPIC_API_KEY=<anthropic-api-key>
```
<!-- /Usage: Automatically Generated -->

<!-- Options: Automatically Generated -->
## Options

You can control a variety of options from the command line. For example:

```bash
inspect eval inspect_evals/piqa --limit 10
inspect eval inspect_evals/piqa --max-connections 10
inspect eval inspect_evals/piqa --temperature 0.5
```

See `inspect eval --help` for all available options.
<!-- /Options: Automatically Generated -->

## Dataset
Here is an example prompt from the dataset (after it has been further processed by Inspect):

>The entire content of your response should be of the following format: 'ANSWER:\n$LETTER' (without quotes) where LETTER is one of A,B.
>
>Given either a question or a statement followed by two possible solutions labelled A and B, choose the most appropriate solution. If a question is given, the solutions answer the question. If a statement is given, the solutions explain how to achieve the statement.
>
>How do I ready a guinea pig cage for it's new occupants?
>
>A) Provide the guinea pig with a cage full of a few inches of bedding made of ripped paper strips, you will also need to supply it with a water bottle and a food dish.  
>B) Provide the guinea pig with a cage full of a few inches of bedding made of ripped jeans material, you will also need to supply it with a water bottle and a food dish.  

The model is then tasked to pick the correct choice.

## Scoring
A simple accuracy is calculated over the datapoints.
