"""
Pre-Flight: Airport Ground Operations Safety Knowledge Evaluation

This evaluation benchmark tests model understanding of aviation regulations including ICAO annexes,
flight dispatch rules, pilot procedures, and airport ground operations safety protocols.

Developed by Airside Labs (https://airsidelabs.com)
A specialized aviation sector software, data, and AI experimentation startup focused on
accelerating innovation and optimizing operations through data-driven insights.
"""

from inspect_ai import Task, task
from inspect_ai.dataset import hf_dataset
from inspect_ai.scorer import choice
from inspect_ai.solver import multiple_choice


@task
def pre_flight() -> Task:
    """Evaluate understanding of airport ground operations safety and aviation regulations."""
    return Task(
        dataset=hf_dataset(path="AirsideLabs/pre-flight-06", split="test"),
        solver=multiple_choice(),
        scorer=choice(),
    )
