from inspect_ai.dataset import Sample

from inspect_evals.aime2024.aime2024 import record_to_sample


def test_record_to_sample():
    example_record = {
        "ID": "2024-II-4",
        "Problem": """Let $x,y$ and $z$ be positive real numbers that satisfy the following system of equations:
\\[\\log_2\\left({x \\over yz}\\right) = {1 \\over 2}\\]
\\[\\log_2\\left({y \\over xz}\\right) = {1 \\over 3}\\]
\\[\\log_2\\left({z \\over xy}\\right) = {1 \\over 4}\\]
Then the value of $\\left|\\log_2(x^4y^3z^2)\\right|$ is $\\tfrac{m}{n}$ where $m$ and $n$ are relatively prime positive integers. Find $m+n$.""",
        "Solution": """Denote $\\log_2(x) = a$, $\\log_2(y) = b$, and $\\log_2(z) = c$.

Then, we have:
$a-b-c = \\frac{1}{2}$,
$-a+b-c = \\frac{1}{3}$,
$-a-b+c = \\frac{1}{4}$.

Now, we can solve to get $a = \\frac{-7}{24}, b = \\frac{-9}{24}, c = \\frac{-5}{12}$.
Plugging these values in, we obtain $|4a + 3b + 2c|  = \\frac{25}{8} \\implies \\boxed{033}$.""",
        "Answer": 33,
    }

    sample = record_to_sample(example_record)

    assert isinstance(sample, Sample)

    assert sample.id == example_record["ID"]
    assert sample.input == example_record["Problem"]
    assert sample.target == str(example_record["Answer"])
    assert sample.metadata["solution"] == example_record["Solution"]
    assert sample.choices is None
    assert sample.sandbox is None
    assert sample.files is None
    assert sample.setup is None
