import tarfile
from unittest.mock import AsyncMock, MagicMock

import pytest


@pytest.fixture
def mock_sandbox():
    sandbox_mock = MagicMock()
    sandbox_mock.read_file = AsyncMock()
    return sandbox_mock


@pytest.fixture
def sample_gt_result():
    """Sample ground truth result with multiple trials"""
    return [
        {
            "numeric_question1": 5.0,
            "numeric_question2": 10.0,
            "fig_numeric_question": 15.0,
            "list_question": [1, 2, 3],
            "string_question": "hello",
        },
        {
            "numeric_question1": 5.5,
            "numeric_question2": 9.5,
            "fig_numeric_question": 14.5,
            "list_question": [1, 2],
            "string_question": "hello",
        },
    ]


@pytest.fixture
def test_record():
    return {
        "capsule_id": "test_capsule",
        "field": "Computer Science",
        "language": "Python",
        "task_prompt": "Test prompt",
        "results": [{"key1": "value1", "key2": 42}],
    }


@pytest.fixture
def mock_tarball():
    mock_member = MagicMock()
    mock_member.name = "test_capsule/REPRODUCING.md"
    mock_tar = MagicMock(spec=tarfile.TarFile)
    mock_tar.getmembers.return_value = [mock_member]
    return mock_tar


@pytest.fixture
def mock_dataset():
    dataset_mock = MagicMock()
    return dataset_mock


@pytest.fixture
def mock_model():
    model_mock = MagicMock()
    model_mock.name = "gpt-4o"
    return model_mock


@pytest.fixture
def sample_agent_result():
    """Sample agent result with string values that can be converted to float"""
    return {
        "numeric_question1": "5.2",
        "numeric_question2": "9.8%",
        "fig_numeric_question": "15.2",
        "string_question": "Hello",
    }


@pytest.fixture
def mock_openai_client():
    """Mock for OpenAI client"""
    mock_client = MagicMock()
    mock_completion = MagicMock()
    mock_choice = MagicMock()
    mock_message = MagicMock()

    # Setup the response chain
    mock_message.content = "This is a test response from the vision model"
    mock_choice.message = mock_message
    mock_completion.choices = [mock_choice]
    mock_client.chat.completions.create.return_value = mock_completion

    return mock_client
