import os
from unittest.mock import patch


def test_core_bench_function_exists():
    """Simple test to verify the core_bench function exists and can be imported."""
    from inspect_evals.core_bench.core_bench import core_bench

    # Verify it's callable
    assert core_bench is not None
    assert callable(core_bench)


@patch.dict(os.environ, {"OPENAI_API_KEY": "dummy_key_for_testing"})
def test_default_solver_with_dummy_key():
    from inspect_evals.core_bench.core_bench import default_solver

    solver = default_solver()
    assert solver is not None
    assert callable(solver)


@patch.dict(os.environ, {"OPENAI_API_KEY": "dummy_key_for_testing"})
def test_default_solver_passes_custom_parameters():
    from inspect_evals.core_bench.core_bench import default_solver

    custom_messages = 15
    custom_token_limit = 1234
    custom_model = "custom-model"

    solver = default_solver(
        max_messages=custom_messages,
        token_limit=custom_token_limit,
        vllm_model=custom_model,
    )

    assert solver is not None
    assert callable(solver)
