from inspect_ai.scorer import Metric, SampleScore, Score

from inspect_evals.ifeval import if_metric


def test_ifeval_metric():
    metric: Metric = if_metric()
    result = metric(
        [
            SampleScore(
                score=Score(
                    value={
                        "inst_level_loose": 4,
                        "inst_level_strict": 1,
                        "prompt_level_loose": 1,
                        "prompt_level_strict": 0,
                        "num_instructions": 4,
                    }
                )
            ),
            SampleScore(
                score=Score(
                    value={
                        "inst_level_loose": 1,
                        "inst_level_strict": 1,
                        "prompt_level_loose": 1,
                        "prompt_level_strict": 1,
                        "num_instructions": 1,
                    }
                )
            ),
        ]
    )

    assert result["final_acc"] == 0.25 * (
        result["prompt_strict_acc"]
        + result["prompt_loose_acc"]
        + result["inst_strict_acc"]
        + result["inst_loose_acc"]
    )
    assert result["prompt_strict_acc"] == 0.5
    assert result["prompt_loose_acc"] == 1.0
    assert result["inst_strict_acc"] == 0.4
    assert result["inst_loose_acc"] == 1.0

    assert result["prompt_strict_stderr"] == 0.5
    assert result["prompt_loose_stderr"] == 0.0

    assert round(result["inst_strict_stderr"], 10) == 0.24
    assert result["inst_loose_stderr"] == 0.0

    assert round(result["final_stderr"], 10) == 0.41
