from inspect_evals.lab_bench.utils import convert_bytes_to_base64_encoded_image


def test_convert_bytes_to_base64_encoded_image_jpeg():
    byte_data = b"\xff\xd8\xff\xe0"  # Minimal JPEG header
    result = convert_bytes_to_base64_encoded_image("image/jpeg", byte_data)
    expected_prefix = "data:image/jpeg;base64,"
    assert result.startswith(expected_prefix)


def test_convert_bytes_to_base64_encoded_image_png():
    byte_data = b"\x89PNG\r\n\x1a\n"  # Minimal PNG header
    result = convert_bytes_to_base64_encoded_image("image/png", byte_data)
    expected_prefix = "data:image/png;base64,"
    assert result.startswith(expected_prefix)
