import pytest
from inspect_ai.scorer import (
    CORRECT,
    INCORRECT,
    Metric,
    SampleScore,
    Score,
    accuracy,
)

from inspect_evals.mmiu.mmiu import accuracy_in_category

overall_accuracy: Metric = accuracy()


def test_overall_accuracy_metric():
    scores = [
        SampleScore(score=Score(value=CORRECT)),
        SampleScore(score=Score(value=INCORRECT)),
        SampleScore(score=Score(value=CORRECT)),
        SampleScore(score=Score(value=INCORRECT)),
    ]
    result = overall_accuracy(scores)
    assert result == pytest.approx(0.5)  # (1 + 0.0 + 1.0 + 0.0) / 4


categorized_accuracy: Metric = accuracy_in_category()


def test_categorized_accuracy_metric():
    scores = [
        SampleScore(
            score=Score(
                value=CORRECT, metadata={"task_name": "forensic_detection_blink"}
            )
        ),
        SampleScore(
            score=Score(
                value=INCORRECT, metadata={"task_name": "forensic_detection_blink"}
            )
        ),
        SampleScore(
            score=Score(
                value=CORRECT, metadata={"task_name": "emotion_recognition_expw"}
            )
        ),
        SampleScore(
            score=Score(
                value=CORRECT, metadata={"task_name": "emotion_recognition_expw"}
            )
        ),
    ]
    result = categorized_accuracy(scores)
    assert result == {
        "forensic_detection_blink": 0.5,
        "emotion_recognition_expw": 1.0,
    }
