import pytest
from inspect_ai.dataset import Dataset

from inspect_evals.pre_flight import pre_flight


@pytest.mark.huggingface
def test_pre_flight_structure():
    """Test that the pre_flight task has the expected structure."""
    task = pre_flight()

    # Check that the task has the expected components
    assert task is not None
    assert isinstance(task.dataset, Dataset)

    # Functions can't be compared directly by value, just check they are callable
    from inspect import isfunction

    assert isfunction(task.solver) or callable(task.solver)

    # Check that the scorer is the correct type
    if isinstance(task.scorer, list):
        # If scorer is a list, check each item
        assert len(task.scorer) > 0
        for scorer in task.scorer:
            assert isfunction(scorer) or callable(scorer)
    else:
        # If scorer is a single function
        assert isfunction(task.scorer) or callable(task.scorer)

    # Check that the dataset has some samples
    assert len(task.dataset) > 0

    # Check that each sample has the expected structure
    sample = task.dataset[0]
    assert hasattr(sample, "input")
    assert hasattr(sample, "choices")
    assert hasattr(sample, "target")
    assert isinstance(sample.choices, list)
    assert len(sample.choices) >= 2  # Multiple choice should have at least 2 options
