# SWE-bench Documentation

This directory contains comprehensive documentation for SWE-bench.

## Directory Structure

- **index.md**: Main documentation landing page with overview and quick links
- **installation.md**: Complete installation instructions
- **faq.md**: Frequently asked questions
- **guides/**: Step-by-step guides for common tasks
  - **quickstart.md**: Getting started with SWE-bench
  - **evaluation.md**: How to evaluate models
  - **docker_setup.md**: Detailed Docker configuration guide
  - **datasets.md**: Information about available datasets
  - **create_rag_datasets.md**: How to create custom RAG datasets
- **reference/**: Detailed API and technical references
  - **harness/**: Documentation for the evaluation harness
  - **inference/**: Documentation for model inference
  - **versioning.md**: Explanation of the versioning system
- **api/**: API documentation (reserved for future use)

## Documentation Maintenance

When updating the documentation:

1. Keep the structure consistent
2. Ensure cross-references between documents are correct
3. Update the main index.md when adding new sections
4. Test code examples to ensure they work properly

## Contributing Documentation

When contributing to the documentation:

1. Follow the existing style and formatting
2. Use Markdown for all documents
3. Include practical examples when explaining features
4. Cross-reference related documentation sections

## Documentation Roadmap

Future documentation improvements:

1. Add more code examples and tutorials
2. Create video tutorials for complex tasks
3. Develop auto-generated API documentation
4. Expand troubleshooting guides with common issues 