#!/bin/bash
   # Script to reproduce results

 Foldername="0513_room5_expert_oracle"
 mkdir out_logs/${Foldername} &> /dev/null
# mkdir /home/zll/projects/qplex/data/${Foldername} &> /dev/null
 #"corridor" "3s5z_vs_3s6z" "5s10z" "7s7z" "1c3s8z_vs_1c3s9z" "8c_vs_30z"
 declare -a tasks=( "room5" )
 ## "5s10z" "7s7z" "2c_vs_64zg" "6h_vs_8z" "MMM2" "3s5z_vs_3s6z"
 declare -a algos=("offpg_categorical_qmix_comm" )
 ##
 declare -a seeds=( "10033" )

 n=0
 gpunum=4
 for task in "${tasks[@]}"
 do
 for algo in "${algos[@]}"
 do
 for seed in "${seeds[@]}"
 do

 if [ ${task} == 'rader2' ]; then
 OMP_NUM_THREADS=16 KMP_AFFINITY="compact,granularity\=fine" CUDA_VISIBLE_DEVICES=${n} nohup python3 main_offpg_comm.py \
 --config=${algo} --env-config=radar2 \
 >& out_logs/${Foldername}/${task}_${algo}_${seed}.txt &

 elif [ ${task} == 'room5' ]; then
  OMP_NUM_THREADS=16 KMP_AFFINITY="compact,granularity\=fine" CUDA_VISIBLE_DEVICES=${n} nohup python3 main_offpg_comm_noicq.py \
 --config=${algo} --env-config=room5 \
 >& out_logs/${Foldername}/${task}_${algo}_${seed}.txt &
 else
 OMP_NUM_THREADS=16 KMP_AFFINITY="compact,granularity\=fine" CUDA_VISIBLE_DEVICES=${n} nohup python3 main_offpg_comm.py \
 --config=${algo} --env-config=sc2 with env_args.map_name=${task} \
 env_args.seed=${seed} \
 >& out_logs/${Foldername}/'sc2_'${task}_${algo}_${seed}.txt &
 fi
 echo "task: ${task}, algo: ${algo}, seed: ${seed}, GPU: $n"
 n=$[($n+1) % ${gpunum}]
 sleep 10
 done
 done
 done