from .basic_controller import BasicMAC
from .cate_broadcast_comm_controller import CateBCommMAC
from .cate_broadcast_comm_controller_full import CateBCommFMAC
from .cate_broadcast_comm_controller_full_mlev28 import CateBCommFMAC28
from .cate_broadcast_comm_controller_cen import CateBCommCMAC
from .cate_broadcast_comm_controller_cenv1 import CateBCommCMAC1
from .cate_broadcast_comm_controller_avg import CateBCommAMAC
from .cate_broadcast_comm_controller_full_sche import CateBCommScheMAC
from .cate_broadcast_comm_controller_not_IB import CateBCommNIBMAC
from .tar_comm_controller import TarCommMAC
from .cate_pruned_broadcast_comm_controller import CatePBCommMAC
from .cate_broadcast_comm_controller_simi import CateBCommSMAC
from .cate_broadcast_comm_controller_simicomb import CateBCommSCMAC
from .cate_broadcast_comm_controller_simimle import CateBCommSLMAC
from .cate_broadcast_comm_controller_simimle_mlev28 import CateBCommSLMAC28
from .cate_broadcast_comm_controller_similv import CateBCommSVMAC

REGISTRY = {"basic_mac": BasicMAC,
            "cate_broadcast_comm_mac": CateBCommMAC,
            "cate_broadcast_comm_mac_full": CateBCommFMAC,
            "cate_broadcast_comm_mac_full_mlev28": CateBCommFMAC28,
            "cate_broadcast_comm_mac_cen": CateBCommCMAC,
            "cate_broadcast_comm_mac_cenv1": CateBCommCMAC1,
            "cate_broadcast_comm_mac_avg": CateBCommAMAC,
            "cate_broadcast_comm_mac_simi": CateBCommSMAC,
            "cate_broadcast_comm_mac_simicomb": CateBCommSCMAC,
            "cate_broadcast_comm_mac_simimle": CateBCommSLMAC,
            "cate_broadcast_comm_mac_simimle28": CateBCommSLMAC28,
            "cate_broadcast_comm_mac_similv": CateBCommSVMAC,
            "cate_broadcast_comm_mac_full_sche": CateBCommScheMAC,
            "cate_broadcast_comm_mac_not_IB": CateBCommNIBMAC,
            "tar_comm_mac": TarCommMAC,
            "cate_pruned_broadcast_comm_mac": CatePBCommMAC}
