from .q_learner import QLearner
from .coma_learner import COMALearner
from .categorical_q_learner import CateQLearner
from .categorical_q_learner_ptdb import CateQLearnerPTDB
from .cdq_categorical_q_learner import CDQCateQLearner
from .offpg_learner import OffPGLearner
from .offpg_learner_simi import OffPGLearnerS
from .offpg_learner_simicomb import OffPGLearnerSC
from .offpg_learner_simift import OffPGLearnerSF
from .offpg_learner_simimle import OffPGLearnerSL
from .offpg_learner_similv import OffPGLearnerSV
from .offpg_learner_comm import OffPGLearnerComm
from .offpg_learner_comm_sche import OffPGLearnerCommSche


REGISTRY = {
    "q_learner": QLearner,
    "coma_learner": COMALearner,
    "cate_q_learner": CateQLearner,
    "cate_q_learner_ptdb": CateQLearnerPTDB,
    "cdq_cate_q_learner": CDQCateQLearner,
    "offpg_learner": OffPGLearner,
    "offpg_learner_simi": OffPGLearnerS,
    "offpg_learner_simicomb": OffPGLearnerSC,
    "offpg_learner_simift": OffPGLearnerSF,
    "offpg_learner_simimle": OffPGLearnerSL,
    "offpg_learner_similv": OffPGLearnerSV,
    "offpg_learner_comm": OffPGLearnerComm,
    "offpg_learner_comm_sche": OffPGLearnerCommSche
}
