#include <cstdio>
#include <cstring>
#include <vector>
using std::vector;
#define MAXN 100005
#define MAXH 405
int indeg[MAXH],outdeg[MAXH];
bool vis[MAXH];
vector<int> G[MAXH];
void add_edge(int u,int v)
{
    outdeg[u]++;indeg[v]++;
    G[u].push_back(v);G[v].push_back(u);
}
bool dfs(int v)
{
    bool f=indeg[v]!=outdeg[v];
    vis[v]=true;
    for(auto to:G[v])
    {
        if(!vis[to]) 
            f|=dfs(to);
    }
    return f;
}
int main()
{
    int N,H;
    int a[MAXN],b[MAXN],c[MAXN],d[MAXN];
    scanf("%d%d",&N,&H);
    for(int i=1;i<=N;i++) 
    {
        scanf("%d%d%d%d",&a[i],&b[i],&c[i],&d[i]);
        int l,r;
        l= ( c[i]==0 ? a[i] : -c[i] );
        r= ( d[i]==0 ? -b[i] : d[i] );
        add_edge(l+H,r+H);
    }
    bool flag=true;
    for(int i=0;flag && i<=H;i++) 
    {
        if(outdeg[i]>indeg[i]) 
            flag=false;
    }
    for(int i=H+1;flag && i<=2*H;i++)
    {
        if(indeg[i]>outdeg[i]) 
             flag=false;
    }
    memset(vis,false,sizeof(vis));
    for(int i=0;flag && i<=2*H;i++)
    {
        if((indeg[i]||outdeg[i])&&!vis[i]) 
            flag &=dfs(i);
    }
    if(flag) 
    {
        printf("YES\n"); 
    }
    else
    { 
        printf("NO\n");
    }
    return 0;
}