#include<iostream>
#include<utility>
#include<climits>
typedef std::pair<int, int> P;
const int MAX_N = 1 << 17;
int n;
// fst: -得点, snd: チームの番号
P dat[MAX_N * 2 - 1];
int cnt[MAX_N];
void init( int n_ )
{
	n = 1;
	while( n < n_ )
		n *= 2;
	for( int i = 0; i != n * 2 - 1; ++i )
		dat[i] = std::make_pair( INT_MAX, INT_MAX );
	return;
}
void update( int k, P x )
{
	k += n - 1;
	dat[k] = x;
	while( k > 0 )
	{
		k = (k - 1) / 2;
		dat[k] = std::min( dat[k*2+1], dat[k*2+2] );
	}
	return;
}
// [a,b)
P query( int a, int b, int k, int l, int r )
{
	if( a >= r || b <= l )
		return std::make_pair( INT_MAX, INT_MAX );
	
	if( a <= l && r <= b )
		return dat[k];
	else
	{
		P vl = query( a, b, k * 2 + 1, l, (l + r) / 2 );
		P vr = query( a, b, k * 2 + 2, (l + r) / 2, r );
		
		return std::min( vl, vr );
	}
}
int main()
{
	int N, R, L;
	std::cin >> N >> R >> L;
	init( N );
	for( int i = 0; i != N; ++i )
		update( i, std::make_pair( 0, i ) );
	int prevT = 0;
	for( int i = 0; i != R; ++i )
	{
		int d, t, x;
		std::cin >> d >> t >> x;
		--d;
		if( t != prevT )
		{
			P p = query( 0, N, 0, 0, n );
			cnt[p.second] += t - prevT;
		}
		P p = query( d, d + 1, 0, 0, n );
		update( d, std::make_pair( p.first - x, p.second ) );
		prevT = t;
	}
	if( prevT != L )
	{
		P p = query( 0, N, 0, 0, n );
		cnt[p.second] += L - prevT;
	}
	int t = -1, id;
	for( int i = 0; i != N; ++i )
	{
		if( t < cnt[i] )
		{
			t = cnt[i];
			id = i + 1;
		}
	}
	
	std::cout << id << std::endl;
	return 0;
}