#include <iostream>  
#include <cstdio>  
#include <cstring>  
#include <algorithm>  
#include <cmath>  
#include <string>  
#include <map>  
#include <stack>  
#include <vector>  
#include <set>  
#include <queue>  
#pragma comment (linker,"/STACK:102400000,102400000")  
#define maxn 10000+10  
#define MAXN 2005  
#define mod 1000000009  
#define INF 0x3f3f3f3f  
#define pi acos(-1.0)  
#define eps 1e-6  
#define lson rt<<1,l,mid  
#define rson rt<<1|1,mid+1,r  
typedef long long ll;  
using namespace std;  
  
struct Edge  
{  
    int u,v;  
    double dis;  
}edge[maxn*maxn/2];  
  
int N,M;  
int father[maxn];  
double x[maxn],y[maxn];  
  
int cmp(Edge x,Edge y)  
{  
    return x.dis>y.dis;  
}  
  
void init(int n)  
{  
    for (int i=1;i<=n;i++)  
        father[i]=i;  
}  
  
int find_father(int x)  
{  
    if (x!=father[x])  
        father[x]=find_father(father[x]);  
    return father[x];  
}  
  
double Kruskal()  
{  
    double s=0;  
    for (int i=0;i<M;i++)  
    {  
        int fu=find_father(edge[i].u);  
        int fv=find_father(edge[i].v);  
        if (fu!=fv)  
        {  
            father[fu]=fv;  
            s+=edge[i].dis;     //不需要破?的?的?度之和  
        }  
    }  
    return s;  
}  
  
int main()  
{  
    while (~scanf("%d%d",&N,&M))  
    {  
        init(N);  
        for (int i=1;i<=N;i++)  
            scanf("%lf%lf",&x[i],&y[i]);  
        int u,v;  
        double sum=0.0;  
        for (int i=0;i<M;i++)  
        {  
            scanf("%d%d",&u,&v);  
            edge[i].u=u;  
            edge[i].v=v;  
            edge[i].dis=sqrt( (x[u]-x[v])*(x[u]-x[v])+(y[u]-y[v])*(y[u]-y[v]) );  
            sum+=edge[i].dis;       //sum存下所有?的?度之和  
        }  
        sort(edge,edge+M,cmp);  
        printf("%.3f\n",sum-Kruskal());  
    }  
    return 0;  
}