#include <cstdio>
#include <vector>
#include <algorithm>
#include <string>
#include <map>
#include <set>
#include <queue>
#include <cstring>
using namespace std;
#define reep(i,f,t) for(int i=f ; i<int(t) ; ++i)
#define rep(i,n) reep(i, 0, n) 
typedef vector<int> vi;
typedef vector<vi> vvi;
typedef pair<int,int> pii;
pii fit(const vvi& window, const vvi& pic, int y, int x)
{
	int m = pic.size();
	pii ans(-1, -1);
	rep(i, m) rep(j, m){
		if(pic[i][j] == -1)
			continue;
		
		if(window[y+i][x+j] != pic[i][j]){
			return pii(-1, -1);
		}else if(ans.first == -1)
			ans = pii(y+i, x+j);
	}
	return ans;
}
void rotate(vvi& p)
{
	int m = p.size();
	vvi next(m, vi(m));
	rep(i, m) rep(j, m)
		next[i][j] = p[m-j-1][i];
	
	p.swap(next);
}
int main()
{
	int n, m;
	while(scanf("%d%d", &n, &m), n){
		vvi window(n, vi(n));
		rep(i, n) rep(j, n)
			scanf("%d", &window[i][j]);
		
		vvi pic(m, vi(m));
		rep(i, m) rep(j, m)
			scanf("%d", &pic[i][j]);
		
		pii ans(-1, -1);
		rep(i, n-m+1) rep(j, n-m+1){
			rep(k, 4){
				ans = fit(window, pic, i, j);
				if(ans.first != -1){
					i=n-m+1;
					j=n-m+1;
					break;
				}
				rotate(pic);
			}
		}
		
		if(ans.first == -1)
			puts("NA");
		else
			printf("%d %d\n", ans.second+1, ans.first+1);
	}
	
	return 0;
}