# from Layers import layers

# from peft.tuners import lora

from peft.tuners.lora import layer

# from

def masks(module):
    r"""Returns an iterator over modules masks, yielding the mask.
    """
    for name, buf in module.named_buffers():
        if "mask" in name:
            yield buf

def trainable(module):
    r"""Returns boolean whether a module is trainable.
    """
    return not isinstance(module, (layer.SparseLinear))

def prunable(module):
    r"""Returns boolean whether a module is prunable.
    """
    isprunable = isinstance(module, layer.SparseLinear)

    return isprunable

def parameters(model):
    r"""Returns an iterator over models trainable parameters, yielding just the
    parameter tensor.
    """
    for module in filter(lambda p: trainable(p), model.modules()):
        for param in module.parameters(recurse=False):
            yield param

def masked_parameters(model):
    r"""Returns an iterator over models prunable parameters, yielding both the
    mask and parameter tensors.
    """
    for module in filter(lambda p: prunable(p), model.modules()):
        for mask, param in zip(masks(module), module.parameters(recurse=False)):
                yield mask, param
