"""Quantile-Guided Alignment (QA).

A framework for aligning language models with risk-calibrated constraints.
"""

__version__ = "0.1.0"

from alignqa.core import align_values, align_with_reward_models
from alignqa.training import train_ppo, train_dpo, train_dpo_with_reward_model
from alignqa.models.reward_models import list_available_reward_models

__all__ = [
    "align_values",
    "align_with_reward_models",
    "train_ppo",
    "train_dpo",
    "train_dpo_with_reward_model",
    "list_available_reward_models"
]
