"""Data handling utilities for Quantile-Guided Alignment (QA).

This module provides utilities for data handling and processing
for the QA framework, including dataset retrieval and results processing.
"""

from alignqa.data.data_retrieval import (
    get_dataset,
    register_dataset,
    list_available_datasets,
    get_dataset_samples,
    get_dataset_prompts
)

from alignqa.data.results_processor import (
    process_reward_results,
    calculate_reward_statistics,
    save_reward_results,
    load_reward_results
)

__all__ = [
    'get_dataset',
    'register_dataset',
    'list_available_datasets',
    'get_dataset_samples',
    'get_dataset_prompts',
    'process_reward_results',
    'calculate_reward_statistics',
    'save_reward_results',
    'load_reward_results'
] 