import pandas as pd

def excel_to_json(excel_file, json_file):
    # 读取Excel文件
    df = pd.read_excel(excel_file)

    # 将数据框转换为JSON格式并保存到文件
    df.to_json(json_file, orient='records', force_ascii=False, indent=4)

def json_to_excel(json_file, excel_file):
    # 读取JSON文件
    df = pd.read_json(json_file)

    # 将数据框保存到Excel文件
    df.to_excel(excel_file, index=False)
    

excel_to_json('hisen.xlsx', 'hisen.json')