import json

def get_baseline(input_path):
    with open(input_path, 'r') as f:
        dataset = json.load(f)
    baselines = ['GPT_score', 'BERT_score', 'ROUGE_score', 'BLEU_score', 'BART_score', 'BLEURT_score', 'UNIEVAL_score']
    modes_complex = ['human_a', 'human_b', 'model_a', 'model_b']
    modes_simple = ['model_a', 'model_b']
    human_answers_a = []
    human_answers_b = []
    model_answers_a = []
    model_answers_b = []
    for data in dataset:
        if 'geo' in input_path or 'his' in input_path or 'pol' in input_path:
            for baseline in baselines:
                human_answers_a.append(data[f"{baseline}_human_a_rounded"])
                human_answers_b.append(data[f"{baseline}_human_b_rounded"])
                model_answers_a.append(data[f"{baseline}_model_a_rounded"])
                model_answers_b.append(data[f"{baseline}_model_b_rounded"])
                if baseline == 'GPT_score':
                    if human_answers_a[-1] < human_answers_b[-1]:
                        data['GPT2_human_vs_human'] = 'human_a'
                    elif human_answers_a[-1] > human_answers_b[-1]:
                        data['GPT2_human_vs_human'] = 'human_b'
                    else:
                        data['GPT2_human_vs_human'] = 'tie'
                else:
                    if human_answers_a[-1] > human_answers_b[-1]:
                        data[f"{baseline}_human_vs_human"] = 'human_a'
                    elif human_answers_a[-1] < human_answers_b[-1]:
                        data[f"{baseline}_human_vs_human"] = 'human_b'
                    else:
                        data[f"{baseline}_human_vs_human"] = 'tie'
                if baseline == 'GPT_score':
                    if model_answers_a[-1] < model_answers_b[-1]:
                        data['GPT2_model_vs_model'] = 'model_a'
                    elif model_answers_a[-1] > model_answers_b[-1]:
                        data['GPT2_model_vs_model'] = 'model_b'
                    else:
                        data['GPT2_model_vs_model'] = 'tie'
                else:
                    if model_answers_a[-1] > model_answers_b[-1]:
                        data[f"{baseline}_model_vs_model"] = 'model_a'
                    elif model_answers_a[-1] < model_answers_b[-1]:
                        data[f"{baseline}_model_vs_model"] = 'model_b'
                    else:
                        data[f"{baseline}_model_vs_model"] = 'tie'
                if baseline == 'GPT_score':
                    if human_answers_a[-1] < model_answers_a[-1]:
                        data['GPT2_human_a_vs_model_a'] = 'human_a'
                    elif human_answers_a[-1] > model_answers_a[-1]:
                        data['GPT2_human_a_vs_model_a'] = 'model_a'
                    else:
                        data['GPT2_human_a_vs_model_a'] = 'tie'
                    if human_answers_a[-1] < model_answers_b[-1]:
                        data['GPT2_human_b_vs_model_b'] = 'human_a'
                    elif human_answers_a[-1] > model_answers_b[-1]:
                        data['GPT2_human_b_vs_model_b'] = 'model_b'
                    else:
                        data['GPT2_human_b_vs_model_b'] = 'tie'
                else:
                    if human_answers_a[-1] > model_answers_a[-1]:
                        data[f"{baseline}_human_a_vs_model_a"] = 'human_a'
                    elif human_answers_a[-1] < model_answers_a[-1]:
                        data[f"{baseline}_human_a_vs_model_a"] = 'model_a'
                    else:
                        data[f"{baseline}_human_a_vs_model_a"] = 'tie'
                    if human_answers_a[-1] > model_answers_b[-1]:
                        data[f"{baseline}_human_b_vs_model_b"] = 'human_a'
                    elif human_answers_a[-1] < model_answers_b[-1]:
                        data[f"{baseline}_human_b_vs_model_b"] = 'model_b'
                    else:
                        data[f"{baseline}_human_b_vs_model_b"] = 'tie'
        else:
            for baseline in baselines:
                for mode in modes_simple:
                    if baseline == 'GPT_score':
                        if data[f"{baseline}_model_a_rounded"] < data[f"{baseline}_model_b_rounded"]:
                            data['GPT2_model_vs_model'] = 'model_a'
                        elif data[f"{baseline}_model_a_rounded"] > data[f"{baseline}_model_b_rounded"]:
                            data['GPT2_model_vs_model'] = 'model_b'
                        else:
                            data['GPT2_model_vs_model'] = 'tie'
                    else:
                        if data[f"{baseline}_model_a_rounded"] > data[f"{baseline}_model_b_rounded"]:
                            data[f"{baseline}_model_vs_model"] = 'model_a'
                        elif data[f"{baseline}_model_a_rounded"] < data[f"{baseline}_model_b_rounded"]:
                            data[f"{baseline}_model_vs_model"] = 'model_b'
                        else:
                            data[f"{baseline}_model_vs_model"] = 'tie'
    out_path = input_path.replace('.json', '_baseline.json')
    with open(out_path, 'w') as f:
        json.dump(dataset, f, indent=4)

                            
                        
                                       
                        
            
                
                    
                
                    
                    
        