from . import language, planner, actor


def create_models(env, FLAGS):
    lang_args = language.get_lang(env, FLAGS)

    planner_fn = planner.Planner
    actor_fn = actor.Actor

    if FLAGS.partial_obs:
        obs_space = env.partial_observation_space.shape
    else:
        obs_space = env.observation_space.shape

    model = actor_fn(
        obs_space,
        env.action_space.n,
        FLAGS,
        **lang_args,
        use_intrinsic_rewards=FLAGS.generator,
    )

    generator_model = planner_fn(
        env.observation_space.shape,
        env.width,
        env.height,
        FLAGS,
        **lang_args,
    )

    return model, generator_model
