import torch


def create_optimizers(learner_model, learner_generator_model, total_frames, FLAGS):
    optimizer = torch.optim.Adam(
        learner_model.parameters(),
        lr=FLAGS.lr,
    )
    
    discriminator_optimizer = torch.optim.Adam(
        learner_model.parameters(),
        lr=FLAGS.lr,
    )

    generator_optimizer = torch.optim.Adam(
        learner_generator_model.parameters(),
        lr=FLAGS.generator_lr,
    )

    def lr_lambda(epoch):
        return (
            1
            - min(
                (epoch * FLAGS.unroll_length * FLAGS.batch_size),
                total_frames,
            )
            / total_frames
        )

    scheduler = torch.optim.lr_scheduler.LambdaLR(optimizer, lr_lambda)
    discriminator_scheduler = torch.optim.lr_scheduler.LambdaLR(discriminator_optimizer, lr_lambda)
    generator_scheduler = torch.optim.lr_scheduler.LambdaLR(
        generator_optimizer, lr_lambda
    )

    return (
        optimizer,
        discriminator_optimizer,
        generator_optimizer,
        scheduler,
        discriminator_scheduler,
        generator_scheduler,
    )
