# A Rigorous Measure of the Complexity of Neural Representations based on Partial Information Decomposition
## TMLR Submission 2022 - Supplementary Code - README

### General
This is part of the supplementary material to our TMLR submission.

### Requirements
All requirements for the *nninfo* package are summarized in the *env.yaml* file.

We recommend setting up a new virtual environment using the conda command:

    conda env create -f env.yaml

### Scripts for reproducing research results
To recreate the figures in the TMLR submission paper, we provide four scripts:
- *1_tmlr_mnist_8levels_onehot.ipynb* creates Figure 3.B
- *2_tmlr_mnist_8levels_binary.ipynb* creates Figure 4.A
- *3_tmlr_mnist_4levels_onehot.ipynb* creates Figures 5.B and 5.D
- *4_tmlr_cifar.ipynb* creates Figure 4.B


The scripts include the whole experiment pipeline from training over analysis to plotting.

As the empirical results (.ipynb files 1-4) of our work were computed on a scientific compute cluster over several days, we recommend not to rerun the experiments entirely but rather to take the scripts as a guideline to examine the nninfo package. 

To make the examination of the experiment pipeline easier, we include a fifth script that runs the analysis on a toy network and dataset:

- *5_tmlr_demo.ipynb* is a faster demo script (can be completely rerun in approximately two hours on a modern desktop machine)
