import logging
import os
from . import log
from . import config
from . import exp
from .exp import *
from . import exp_comp
from .exp_comp import *
from . import file_io
from .file_io import MeasurementManager, FileManager
from . import model
from .model import NeuralNetwork, NoisyNeuralNetwork
from . import plot
from . import task
from .task import TaskManager
from . import analysis
from .analysis import Analysis

__all__ = [
    "log",
    "config",
    "exp",
    "exp_comp",
    "file_io",
    "model",
    "plot",
    "task",
    "analysis",
    "MeasurementManager",
    "FileManager",
    "NeuralNetwork",
    "NoisyNeuralNetwork",
    "TaskManager",
    "Analysis"
]

__all__ += exp.__all__
__all__ += exp_comp.__all__

module_dir = os.path.dirname(__file__) + "/"  # path to this file

logging.basicConfig(
    level=logging.INFO,
    format="%(asctime)s [%(name)-13.13s] [%(levelname)-5.5s]  %(message)s",
    filename=module_dir + "../experiments/nninfo.log",
    filemode="a",
)
logging.getLogger("nninfo").info("STARTUP NNINFO SESSION")
