import nninfo


# set an id for the experiment (creates a new experiment directory with all
# the data
experiment_id = 42

exp = nninfo.exp.Experiment(experiment_id, overwrite_experiment_dir=True)

net_architecture = [12, 10, 8, 6, 4, 1]
net_activ_func = ['input', 'tanh', 'tanh', 'tanh', 'tanh', 'sigmoid']
initializer_name = 'xavier'
net = nninfo.model.NeuralNetwork(net_architecture, net_activ_func, initializer_name)

batch_size = 16
lr = 0.01

# set up all the parts for the training:
# network, trainer, tester and task
trainer = nninfo.exp_comp.Trainer()
tester = nninfo.exp_comp.Tester('full_set')

# once they are set up, they can be connected using this function
# the same modules can also be used in other experiments after this one is done
# for example, everything is modular
exp.connect(network=net, trainer=trainer, tester=tester)
exp.save_components()
exp.disconnect()

exp2 = nninfo.exp.Experiment(experiment_id, load=True)

task = nninfo.task.TaskManager(data_key='fake_dat')
exp2.connect(task=task)

exp2.trainer.set_training_parameters('full_set', batch_size=batch_size, lr=lr,
                                optim_str='SGD', loss_str='BCELoss', n_epochs_chapter=5)
exp2.trainer.train_chapter(12)