# Harmonized Learning with Concurrent Arbitration

## Abstract
Motion planning, regarded as a sequential decision-making problem, poses a challenge for robots in high-dimensional continuous environments due to inefficient sampling. In contrast, humans inherently possess a distinctive advantage in decision-making by leveraging limited information, primarily relying on the concurrent reasoning mechanism in the prefrontal cortex. Motivated by this, we propose a brain-inspired Deep Reinforcement Learning scheme for planning, called Harmonized Learning with Concurrent Arbitration (HLCA). The approach effectively mimics human capacity for concurrent inference tracks and the ability to harmonize strategies. Specifically, in the planning process, a general Concurrent Arbitration Module (CAM) is meticulously crafted to balance the exploration-exploitation dilemma simply and efficiently. Besides, the harmonized style facilitates robots self-improving learning during the learning process, enabling the selection of appropriate strategies to guide planning. Experimental results show that HLCA outperforms the state-of-the-art benchmarks in terms of three representative metrics, which confirms the potential of emulating human-like capabilities to enhance the intelligence and efficiency of robotic planning.

## Installation 
install pytorch
conda install pytorch torchvision torchaudio cudatoolkit=11.3 -c pytorch  
#install torch geometric, refer to https://github.com/pyg-team/pytorch_geometric  
pip install pybullet jupyterlab transforms3d matplotlib shapely descartes  

## Reference
[gnn motion planning](https://github.com/rainorangelemon/gnn-motion-planning)  
[NEXT learning to plan](https://github.com/NeurEXT/NEXT-learning-to-plan)   
[PyBullet planning](https://github.com/caelan/pybullet-planning)  
[PyBullet](https://github.com/bulletphysics/bullet3)
