def new_kuka_file(block):
    block_begin = "<?xml version=\"1.0\" ?>\r\n<robot name=\"lbr_iiwa\" xmlns:xacro=\"http://www.ros.org/wiki/xacro\">\r\n  <!-- Import Rviz colors -->\r\n  <material name=\"Grey\">\r\n    <color rgba=\"0.2 0.2 0.2 1.0\"/>\r\n  </material>\r\n  <material name=\"Orange\">\r\n    <color rgba=\"1.0 0.423529411765 0.0392156862745 1.0\"/>\r\n  </material>\r\n  <material name=\"Blue\">\r\n  <color rgba=\"0.5 0.7 1.0 1.0\"/>\r\n</material>\r\n\r\n  <!--Import the lbr iiwa macro -->\r\n  <!--Import Transmissions -->\r\n  <!--Include Utilities -->\r\n  <!--The following macros are adapted from the LWR 4 definitions of the RCPRG - https://github.com/RCPRG-ros-pkg/lwr_robot -->\r\n  <!--Little helper macros to define the inertia matrix needed for links.-->\r\n  <!--Cuboid-->\r\n  <!--Cylinder: length is along the y-axis! -->\r\n  <!--lbr-->\r\n  <link name=\"lbr_iiwa_link_0\">\r\n    <inertial>\r\n      <origin rpy=\"0 0 0\" xyz=\"-0.1 0 0.07\"/>\r\n      <!--Increase mass from 5 Kg original to provide a stable base to carry the\r\n          arm.-->\r\n      <mass value=\"0.0\"/>\r\n      <inertia ixx=\"0.05\" ixy=\"0\" ixz=\"0\" iyy=\"0.06\" iyz=\"0\" izz=\"0.03\"/>\r\n    </inertial>\r\n    <visual>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_0.obj\"/>\r\n      </geometry>\r\n      <material name=\"Grey\"/>\r\n    </visual>\r\n    <collision>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_0.stl\"/>\r\n      </geometry>\r\n    </collision>\r\n  </link>\r\n  <!-- joint between link_0 and link_1 -->\r\n  <joint name=\"lbr_iiwa_joint_1\" type=\"revolute\">\r\n    <parent link=\"lbr_iiwa_link_0\"/>\r\n    <child link=\"lbr_iiwa_link_1\"/>\r\n    <origin rpy=\"0 0 0\" xyz=\"0 0 0.1575\"/>\r\n    <axis xyz=\"0 0 1\"/>\r\n    <limit effort=\"300\" lower=\"-2.96705972839\" upper=\"2.96705972839\" velocity=\"10\"/>\r\n    <dynamics damping=\"0.5\"/>\r\n  </joint>\r\n  <link name=\"lbr_iiwa_link_1\">\r\n    <inertial>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 -0.03 0.12\"/>\r\n      <mass value=\"4\"/>\r\n      <inertia ixx=\"0.1\" ixy=\"0\" ixz=\"0\" iyy=\"0.09\" iyz=\"0\" izz=\"0.02\"/>\r\n    </inertial>\r\n    <visual>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_1.obj\"/>\r\n      </geometry>\r\n      <material name=\"Blue\"/>\r\n    </visual>\r\n    <collision>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_1.stl\"/>\r\n      </geometry>\r\n    </collision>\r\n  </link>\r\n  <!-- joint between link_1 and link_2, the first joint we need to consider-->\r\n  <joint name=\"lbr_iiwa_joint_2\" type=\"revolute\">\r\n    <parent link=\"lbr_iiwa_link_1\"/>\r\n    <child link=\"lbr_iiwa_link_2\"/>\r\n    <origin rpy=\"1.57079632679   0 3.14159265359\" xyz=\"0 0 0.2025\"/>\r\n    <axis xyz=\"0 0 1\"/>\r\n    <limit effort=\"300\" lower=\"-2.09439510239\" upper=\"2.09439510239\" velocity=\"10\"/>\r\n    <dynamics damping=\"0.5\"/>\r\n  </joint>\r\n  <link name=\"lbr_iiwa_link_2\">\r\n    <inertial>\r\n      <origin rpy=\"0 0 0\" xyz=\"0.0003 0.059 0.042\"/>\r\n      <mass value=\"4\"/>\r\n      <inertia ixx=\"0.05\" ixy=\"0\" ixz=\"0\" iyy=\"0.018\" iyz=\"0\" izz=\"0.044\"/>\r\n    </inertial>\r\n    <visual>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_2.obj\"/>\r\n      </geometry>\r\n      <material name=\"Blue\"/>\r\n    </visual>\r\n    <collision>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_2.stl\"/>\r\n      </geometry>\r\n    </collision>\r\n  </link>\r\n  <!-- joint between link_2 and link_3 -->\r\n  <joint name=\"lbr_iiwa_joint_3\" type=\"revolute\">\r\n    <parent link=\"lbr_iiwa_link_2\"/>\r\n    <child link=\"lbr_iiwa_link_3\"/>\r\n    <origin rpy=\"1.57079632679 0 3.14159265359\" xyz=\"0 0.2045 0\"/>\r\n    <axis xyz=\"0 0 1\"/>\r\n    <limit effort=\"300\" lower=\"-2.96705972839\" upper=\"2.96705972839\" velocity=\"10\"/>\r\n    <dynamics damping=\"0.5\"/>\r\n  </joint>\r\n  <link name=\"lbr_iiwa_link_3\">\r\n    <inertial>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0.03 0.13\"/>\r\n      <mass value=\"3\"/>\r\n      <inertia ixx=\"0.08\" ixy=\"0\" ixz=\"0\" iyy=\"0.075\" iyz=\"0\" izz=\"0.01\"/>\r\n    </inertial>\r\n    <visual>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_3.obj\"/>\r\n      </geometry>\r\n      <material name=\"Orange\"/>\r\n    </visual>\r\n    <collision>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_3.stl\"/>\r\n      </geometry>\r\n    </collision>\r\n  </link>\r\n  <!-- joint between link_3 and link_4 -->\r\n  <joint name=\"lbr_iiwa_joint_4\" type=\"revolute\">\r\n    <parent link=\"lbr_iiwa_link_3\"/>\r\n    <child link=\"lbr_iiwa_link_4\"/>\r\n    <origin rpy=\"1.57079632679 0 0\" xyz=\"0 0 0.2155\"/>\r\n    <axis xyz=\"0 0 1\"/>\r\n    <limit effort=\"300\" lower=\"-2.09439510239\" upper=\"2.09439510239\" velocity=\"10\"/>\r\n    <dynamics damping=\"0.5\"/>\r\n  </joint>\r\n  <link name=\"lbr_iiwa_link_4\">\r\n    <inertial>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0.067 0.034\"/>\r\n      <mass value=\"2.7\"/>\r\n      <inertia ixx=\"0.03\" ixy=\"0\" ixz=\"0\" iyy=\"0.01\" iyz=\"0\" izz=\"0.029\"/>\r\n    </inertial>\r\n    <visual>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_4.obj\"/>\r\n      </geometry>\r\n      <material name=\"Blue\"/>\r\n    </visual>\r\n    <collision>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_4.stl\"/>\r\n      </geometry>\r\n    </collision>\r\n  </link>\r\n"


    def block_middle(id, prev_id):

        return  "<joint name=\"lbr_iiwa_joint%d\" type=\"revolute\">\r\n    <parent link=\"lbr_iiwa_link_%d\"/>\r\n    <child link=\"lbr_iiwa_link_%d\"/>\r\n    <origin rpy=\"1.57079632679 0 3.14159265359\" xyz=\"0 0.1845 0\"/>\r\n    <axis xyz=\"0 0 1\"/>\r\n    <limit effort=\"300\" lower=\"-2.96705972839\" upper=\"2.96705972839\" velocity=\"10\"/>\r\n    <dynamics damping=\"0.5\"/>\r\n  </joint>\r\n  <link name=\"lbr_iiwa_link_%d\">\r\n    <inertial>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0.03 0.13\"/>\r\n      <mass value=\"3\"/>\r\n      <inertia ixx=\"0.08\" ixy=\"0\" ixz=\"0\" iyy=\"0.075\" iyz=\"0\" izz=\"0.01\"/>\r\n    </inertial>\r\n    <visual>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_3.obj\"/>\r\n      </geometry>\r\n      <material name=\"Orange\"/>\r\n    </visual>\r\n    <collision>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_3.stl\"/>\r\n      </geometry>\r\n    </collision>\r\n  </link>\r\n\r\n   <!-- joint between link_5 and link_6 -->\r\n  <joint name=\"lbr_iiwa_joint_%d\" type=\"revolute\">\r\n    <parent link=\"lbr_iiwa_link_%d\"/>\r\n    <child link=\"lbr_iiwa_link_%d\"/>\r\n    <origin rpy=\"1.57079632679 0 0\" xyz=\"0 0 0.2155\"/>\r\n    <axis xyz=\"0 0 1\"/>\r\n    <limit effort=\"300\" lower=\"-2.09439510239\" upper=\"2.09439510239\" velocity=\"10\"/>\r\n    <dynamics damping=\"0.5\"/>\r\n  </joint>\r\n  <link name=\"lbr_iiwa_link_%d\">\r\n    <inertial>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0.067 0.034\"/>\r\n      <mass value=\"2.7\"/>\r\n      <inertia ixx=\"0.03\" ixy=\"0\" ixz=\"0\" iyy=\"0.01\" iyz=\"0\" izz=\"0.029\"/>\r\n    </inertial>\r\n    <visual>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_4.obj\"/>\r\n      </geometry>\r\n      <material name=\"Blue\"/>\r\n    </visual>\r\n    <collision>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_4.stl\"/>\r\n      </geometry>\r\n    </collision>\r\n  </link>\r\n\r\n\r\n" \
                % (id, prev_id, id, id, id+1, id, id+1, id+1)


    block_end = "<!-- joint between link_4 and link_5 -->\r\n  <joint name=\"lbr_iiwa_joint_5\" type=\"revolute\">\r\n    <parent link=\"lbr_iiwa_link_%d\"/>\r\n    <child link=\"lbr_iiwa_link_5\"/>\r\n    <origin rpy=\"-1.57079632679 3.14159265359 0\" xyz=\"0 0.1845 0\"/>\r\n    <axis xyz=\"0 0 1\"/>\r\n    <limit effort=\"300\" lower=\"-2.96705972839\" upper=\"2.96705972839\" velocity=\"10\"/>\r\n    <dynamics damping=\"0.5\"/>\r\n  </joint>\r\n  <link name=\"lbr_iiwa_link_5\">\r\n    <inertial>\r\n      <origin rpy=\"0 0 0\" xyz=\"0.0001 0.021 0.076\"/>\r\n      <mass value=\"1.7\"/>\r\n      <inertia ixx=\"0.02\" ixy=\"0\" ixz=\"0\" iyy=\"0.018\" iyz=\"0\" izz=\"0.005\"/>\r\n    </inertial>\r\n    <visual>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_5.obj\"/>\r\n      </geometry>\r\n      <material name=\"Blue\"/>\r\n    </visual>\r\n    <collision>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_5.stl\"/>\r\n      </geometry>\r\n    </collision>\r\n  </link>\r\n\r\n\r\n  <!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ THE MODIFIED BLOCK ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->\r\n\r\n\r\n  <!-- joint between link_5 and link_6 -->\r\n  <joint name=\"lbr_iiwa_joint_6\" type=\"revolute\">\r\n    <parent link=\"lbr_iiwa_link_5\"/>\r\n    <child link=\"lbr_iiwa_link_6\"/>\r\n    <origin rpy=\"1.57079632679 0 0\" xyz=\"0 0 0.2155\"/>\r\n    <axis xyz=\"0 0 1\"/>\r\n    <limit effort=\"300\" lower=\"-2.09439510239\" upper=\"2.09439510239\" velocity=\"10\"/>\r\n    <dynamics damping=\"0.5\"/>\r\n  </joint>\r\n  <link name=\"lbr_iiwa_link_6\">\r\n    <inertial>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0.0006 0.0004\"/>\r\n      <mass value=\"1.8\"/>\r\n      <inertia ixx=\"0.005\" ixy=\"0\" ixz=\"0\" iyy=\"0.0036\" iyz=\"0\" izz=\"0.0047\"/>\r\n    </inertial>\r\n    <visual>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_6.obj\"/>\r\n      </geometry>\r\n      <material name=\"Orange\"/>\r\n    </visual>\r\n    <collision>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_6.stl\"/>\r\n      </geometry>\r\n    </collision>\r\n  </link>\r\n  <!-- joint between link_6 and link_7 -->\r\n  <joint name=\"lbr_iiwa_joint_7\" type=\"revolute\">\r\n    <parent link=\"lbr_iiwa_link_6\"/>\r\n    <child link=\"lbr_iiwa_link_7\"/>\r\n    <origin rpy=\"-1.57079632679 3.14159265359 0\" xyz=\"0 0.081 0\"/>\r\n    <axis xyz=\"0 0 1\"/>\r\n    <limit effort=\"300\" lower=\"-3.05432619099\" upper=\"3.05432619099\" velocity=\"10\"/>\r\n    <dynamics damping=\"0.5\"/>\r\n  </joint>\r\n  <link name=\"lbr_iiwa_link_7\">\r\n    <inertial>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0.02\"/>\r\n      <mass value=\"0.3\"/>\r\n      <inertia ixx=\"0.001\" ixy=\"0\" ixz=\"0\" iyy=\"0.001\" iyz=\"0\" izz=\"0.001\"/>\r\n    </inertial>\r\n    <visual>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_7.obj\"/>\r\n      </geometry>\r\n      <material name=\"Grey\"/>\r\n    </visual>\r\n    <collision>\r\n      <origin rpy=\"0 0 0\" xyz=\"0 0 0\"/>\r\n      <geometry>\r\n        <mesh filename=\"meshes/link_7.stl\"/>\r\n      </geometry>\r\n    </collision>\r\n  </link>\r\n\r\n  \r\n</robot>" \
        % (7+block*2)
    str = ""
    for id in range(block):
        if id==0:
            str += block_begin
            prev_id = 4
        else:
            prev_id = 7+2*id
        str += block_middle(8+2*id, prev_id)
        if id==(block-1):
            str += block_end

    with open('kuka_iiwa/model_%d.urdf' % block, 'w') as f:
        f.write(str)
