# File: insertion_pivot_alg.py
# Description: Implementation of the (3 + eps)-approximation algorithm in insertion-only streams.


from utils import *

class PivotAlgorithm:
    def __init__(self, vertices_num, k):
        self.vertices_num = vertices_num

        # Initialize a truncated priority queue for each vertex
        self.Q = [TruncatedPriorityQueue(k) for _ in range(vertices_num)]
        for i in range(vertices_num):
            self.Q[i].push(item=i, priority=i + 1)

    def run(self, streaming_edges_file, output_file):
        # Generate a random permutation of the vertices
        self.permutator = Vertexpermutator(self.vertices_num)

        # Read and process the streaming edges
        self.read_stream(streaming_edges_file)

        # Post-process and write the clustering result
        post_process(self.vertices_num, self.Q, self.permutator, output_file)

    def read_stream(self, streaming_edges_file):
        with open(streaming_edges_file, 'r') as f:
            f.readline()
            for line in f:
                u, v, label = line.strip().split()
                u, v = self.permutator.get_permuted_vertexID(int(u)), self.permutator.get_permuted_vertexID(int(v))

                if label == '+':
                    self.Q[u].push(item=v, priority=v + 1)
                    self.Q[v].push(item=u, priority=u + 1)