# File: gen_edges.py
# Description: Extract positive edges and save them as a CSV file.

def gen_edges(streaming_file, pos_edges_file):
    with open(streaming_file, "r") as f:
        f.readline()
        with open(pos_edges_file, "w") as g:
            g.write("node_1,node_2\n")
            for line in f:
                u, v, label = line.strip().split()
                if label == "+":
                    g.write(f"{int(u)},{int(v)}\n")

if __name__ == "__main__":
    streaming_file = "../data/dblp/streaming-dblp10000.txt"
    pos_edges_file = "../data/dblp/dblp10000-edges.csv"
    gen_edges(streaming_file, pos_edges_file)