def parser_add_main_args(parser):
    
    parser.add_argument('--dataset', type=str, default='citeseer')
    parser.add_argument('--data_dir', type=str,
                        default='./data/')
    parser.add_argument('--device', type=int, default=0,
                        help='which gpu to use if any (default: 0)')
    parser.add_argument('--cpu', action='store_true')
    parser.add_argument('--seed', type=int, default=123)
    parser.add_argument('--runs', type=int, default=3,
                        help='number of distinct runs')
    parser.add_argument('--epochs', type=int, default=40)

    
    parser.add_argument('--hidden_channels', type=int, default=64)
    parser.add_argument('--num_layers', type=int, default=2,
                        help='number of layers for deep methods')

    
    parser.add_argument('--backbone_type', type=str, default='gcn', choices=['gcn', 'gat'])
    parser.add_argument('--K', type=int, default=3,
                        help='num of domains, each for one graph convolution filter')
    parser.add_argument('--tau', type=float, default=1,
                        help='temperature for Gumbel Softmax')
    parser.add_argument('--env_type', type=str, default='node', choices=['node', 'graph'])
    parser.add_argument('--lamda', type=float, default=1.0,
                        help='weight for regularlization')
    parser.add_argument('--variant', action='store_true',help='set to use variant')

    
    parser.add_argument('--weight_decay', type=float, default=5e-4)
    parser.add_argument('--dropout', type=float, default=0.0)
    parser.add_argument('--lr', type=float, default=0.01)
    parser.add_argument('--use_bn', action='store_true', help='use batch norm')

    
    parser.add_argument('--use_causal_filter', action='store_true', default=True, help='是否使用因果滤除模块')
    parser.add_argument('--filter_lambda_init', type=float, default=10.0, help='Filter lambda初始值')
    parser.add_argument('--filter_lambda_min', type=float, default=-2.0, help='Filter lambda最小值')
    parser.add_argument('--filter_decay', type=float, default=0.95, help='Filter lambda衰减率')
    parser.add_argument('--filter_temp', type=float, default=1.0, help='Filter temperature')
    parser.add_argument('--filter_residual', type=float, default=0.2, help='Filter residual weight')

    
    parser.add_argument('--display_step', type=int,
                        default=1, help='how often to print')
    parser.add_argument('--store_result', action='store_true',
                        help='whether to store results')
    parser.add_argument('--combine_result', action='store_true',
                        help='whether to combine all the ood environments')
