# Model-Based Transfer RL with Task-Agnostic Offline Pretraining

## Setting up

### Using conda

```
conda env create -f env.yaml
```

## Experiments



### Fine-tuning command on Deepmind Control Suite:

```
python dreamer.py \
--logdir \
path/to/log \
--load_logdir \
path/to/pretrain/model \
--config \
defaults dmc \
--task \
target_dmc_task \
--offline_datadir \
path/to/offline/datasets \
--offline_modeldir \
path/to/teacher/models \
--source_tasks \
['list', 'of', 'source', 'dmc', 'tasks']
```


### Fine-tuning command on Metaworld:

```
python dreamer.py \
--logdir \
path/to/log \
--load_logdir \
path/to/pretrain/model \
--config \
defaults metaworld \
--task \
target_metaworld_task \
--offline_datadir \
path/to/offline/datasets \
--offline_modeldir \
path/to/teacher/models \
--source_tasks \
['list', 'of', 'source', 'metaworld', 'tasks']
```


## Acknowledgements

The codes refer to the implemention of [dreamer-torch](https://github.com/jsikyoon/dreamer-torch). Thanks for the authors！