from hyperparameters import search_space
from log import log_class


class searcher():

    def __init__(self,workspace,search_strategy):
        self.workspace=workspace
        self.search_strategy=search_strategy

        self.search_space_instance = search_space(workspace=self.workspace)
        self.information_instance = log_class(workspace=self.workspace)

        try:
            self.search_history = self.information_instance.read()["search_history"]
        except:
            self.search_history = {}


    def configure(self,connector_choice, mode,filtered_modeling_modules=None,maximum_data_preparation_modules=None):
        self.connector_choice=connector_choice

        self.search_space_instance.configure(mode=mode,connector_choice=self.connector_choice,filtered_modeling_modules=filtered_modeling_modules,maximum_data_preparation_modules=maximum_data_preparation_modules)
        self.search_space_instance.load_logs()
        self.search_space_instance.form_space()
        self.mode=mode
        plans=self.information_instance.read()["plans"]
        task_type=plans[connector_choice]["connector"][0]


        if (mode,self.connector_choice) not in self.search_history:
            self.search_history[(mode,self.connector_choice)]={}
            if task_type=="computer vision" or task_type=="natural language processing":
                self.search_history[(mode , self.connector_choice)]["ZC_proxy"]={}
            self.search_history[(mode , self.connector_choice)]["full"]={}

    def designate(self):
        if self.search_strategy=="random_search":
            configuration=self.search_space_instance.random_search()
        else:
            raise Exception("Search strategy not implemented.")
        return configuration

    def update_search_history_ZC_proxy(self,modeling_choice,score):
        self.search_history[(self.mode , self.connector_choice)]["ZC_proxy"][modeling_choice]=score
        self.information_instance.update_search_history(self.search_history)

    def update_search_history_full(self,configuration,score):
        self.search_history[(self.mode, self.connector_choice)]["full"][configuration]=score
        self.information_instance.update_search_history(self.search_history)
