import time
from openai import OpenAI
import ast

class GPT():

    def __init__(self, key, initial_start_time=0, model="gpt-3.5-turbo"):
        self.previous_start = initial_start_time
        self.model = model
        self.client = OpenAI(
            api_key=key,
        )

    @staticmethod
    def extract_code_from_GPT_turbo(raw_string):
        try:
            sub1 = "```python"
            idx1 = raw_string.index(sub1)
        except:
            try:
                sub1 = "``` python"
                idx1 = raw_string.index(sub1)
            except:
                try:
                    sub1 = "```"
                    idx1 = raw_string.index(sub1)
                except:
                    return raw_string
        sub2 = "```"
        idx2 = raw_string.index(sub2, idx1 + 1, )
        extraction = raw_string[idx1 + len(sub1) + 1: idx2]
        return extraction

    def extract_answer(self,raw_string,mode):
        if mode=="python object":
            raw_string=GPT.extract_code_from_GPT_turbo(raw_string)
            return ast.literal_eval(raw_string)
        elif mode=="python code":
            return self.extract_code_from_GPT_turbo(raw_string)


    def set_initial_time(self):
        self.previous_start = time.time()

    def control_inquiry_frequency(self, minimum_time_interval=20):

        current_start = time.time()
        time_left = minimum_time_interval - (current_start - self.previous_start)
        if time_left >= 0:
            time.sleep(time_left + 0.1)

        self.previous_start = time.time()

    def send_inquiry(self , ret_dic , prompt):

        print("-----Prompt beginning marker-----")
        for prompt_segment in prompt:
            print(prompt_segment["content"])
        print("-----Prompt ending marker-----")

        print("Inquiry sent to GPT, waiting for response...")
        chat_completion = self.client.chat.completions.create(messages=prompt , model=self.model)

        response=chat_completion.choices[0].message.content

        print("-----Response beginning marker-----")
        print(response)
        print("-----Response ending marker-----")

        ret_dic["response"]=response

        return response
