import json
import ast


class log_class():
    def __init__(self , workspace) :
        self.workspace = workspace

        self.task_description = None
        self.plans = None
        self.raw_search_space = None
        self.composite_search_space = None

        self.search_history = None

    def save(self) :
        self.information_category = { "task description" : self.task_description , "plans" : self.plans }

        if self.raw_search_space is not None :
            self.raw_search_space = log_class.convert_search_space(self.raw_search_space , "write" , "raw_search_space")
            self.information_category["raw_search_space"] = self.raw_search_space

        if self.composite_search_space is not None :
            self.composite_search_space = log_class.convert_search_space(self.composite_search_space , "write" ,
                                                                           "composite_search_space")
            self.information_category["composite_search_space"] = self.composite_search_space


        if self.search_history is not None :
            self.search_history = log_class.search_history_conversion(self.search_history , "write")
            self.information_category["search_history"] = self.search_history


        with open(f'{self.workspace}/log.json' , 'w') as f :
            json.dump(self.information_category , f , indent=4)

        if self.raw_search_space is not None :
            self.raw_search_space = log_class.convert_search_space(self.raw_search_space , "read" , "raw_search_space")
        if self.composite_search_space is not None :
            self.composite_search_space = log_class.convert_search_space(self.composite_search_space , "read" ,
                                                                           "composite_search_space")
        if self.search_history is not None :
            self.search_history = log_class.search_history_conversion(self.search_history , "read")

    def read(self):
        with open(f'{self.workspace}/log.json' , 'r') as f :
            log = json.load(f)

        if "task description" in log:
            self.task_description = log["task description"]
        if "plans" in log:
            self.plans = log["plans"]

        returned_objects = {"task description":log["task description"],"plans": log["plans"]}
        if "raw_search_space" in log:
            log["raw_search_space"]=log_class.convert_search_space(log["raw_search_space"] , "read" , "raw_search_space")
            self.raw_search_space = log["raw_search_space"]
            returned_objects["raw_search_space"]=self.raw_search_space
        if "composite_search_space" in log:
            log["composite_search_space"]=log_class.convert_search_space(log["composite_search_space"] , "read" , "composite_search_space")
            self.composite_search_space = log["composite_search_space"]
            returned_objects["composite_search_space"]=self.composite_search_space
        if "search_history" in log:
            log["search_history"]=log_class.search_history_conversion(log["search_history"] , "read")
            self.search_history = log["search_history"]
            returned_objects["search_history"]=self.search_history

        return returned_objects



    def update_raw_search_space(self , raw_search_space) :
        self.read()
        self.raw_search_space = raw_search_space
        self.save()

    def update_composite_search_space(self , composite_search_space) :
        self.read()
        self.composite_search_space = composite_search_space
        self.save()

    def update_plans(self , plans):
        self.read()
        self.plans = plans
        self.save()

    def update_search_history(self , search_history):
        self.read()
        self.search_history = search_history
        self.save()

    @staticmethod
    def convert_search_space(search_space , mode , space_type):
        if space_type== "raw_search_space":
            if mode=="read":
                search_space = { ast.literal_eval(key): value for key, value in search_space.items() }
            if mode=="write":
                search_space = { str(key): value for key, value in search_space.items() }
        if space_type== "composite_search_space":
            for space_key in search_space:
                if mode=="read":
                    for key , value in search_space[space_key].items():
                        ast.literal_eval(key)
                    search_space[space_key] = { ast.literal_eval(key): value for key, value in search_space[space_key].items() }
                if mode=="write":
                    search_space[space_key] = { str(key): value for key, value in search_space[space_key].items() }
        return search_space


    @staticmethod
    def search_history_conversion(search_history, mode):
        converted_dict = { }
        if mode=="write":
            for key , value in search_history.items() :
                if isinstance(key , tuple) :
                    key = str(key)
                if isinstance(value , dict) :
                    value = log_class.search_history_conversion(value , mode)
                converted_dict[key] = value
        if mode=="read":
            for key , value in search_history.items() :
                if isinstance(key , str) :
                    try :
                        key = ast.literal_eval(key)  # Safely evaluate string as tuple
                    except (ValueError , SyntaxError) :
                        pass  # Leave as string if not a valid tuple representation
                if isinstance(value , dict) :
                    value =  log_class.search_history_conversion(value , mode)
                converted_dict[key] = value
        return converted_dict
