def locate_dimension_in_connector(connector_data_format,dimension_name):
    for I_O in ["input","output"]:
        for tensor_idx, tensor in enumerate(connector_data_format[I_O]):
            for dimension_idx, dimension in enumerate(tensor["shape"]):
                if tensor[dimension]["fixed_or_variable"]=="variable":
                    if tensor[dimension]["variable_name"]==dimension_name:
                        return I_O,tensor_idx,dimension_idx
                else :
                    if dimension==dimension_name:
                        return I_O,tensor_idx,dimension_idx

def extract_variable_name(connector_data_format):
    variable_name_list=[]
    for I_O in ["input","output"]:
        for tensor_idx, tensor in enumerate(connector_data_format[I_O]):
            for dimension_idx, dimension in enumerate(tensor["shape"]):
                if tensor[dimension]["fixed_or_variable"]=="variable":
                    variable_name_list.append(tensor[dimension]["variable_name"])
    return variable_name_list