from turtle import st
import numpy as np

class UC_HRL_naive():
    
    def __init__(self, env, K, c, lam):
        self.env = env
        self.K = K        
        self.delta = 1.0 / self.K
        self.d = self.env.nState * self.env.nAction
        
        # phi features
        self.phi = {(s,a): np.zeros(self.d) for s in self.env.states.keys() for a in range(self.env.nAction)}
        i = 0
        for key in self.phi.keys():
            self.phi[key][i] = 1
            i += 1
                    
        # Initialize our Q matrix
        self.Q = {(h,s,a): 0.0 for h in range(self.env.epLen+1) for s in self.env.states.keys() \
                   for a in range(self.env.nAction)}

        # gram matrix
        self.lam = lam
        self.A = {i:  self.lam * np.identity(self.d) for i in self.env.states.keys()}
        self.Ainv = {i:  np.linalg.inv(self.A[i]) for i in self.env.states.keys()}
        
        # transition measure
        self.mu = {i: np.zeros((self.d, self.env.nState)) for i in self.env.states.keys()} 
        self.sums = {i: np.zeros((self.d, self.env.nState)) for i in self.env.states.keys()} 
        
        # confidence raidus param
        self.c = c

    def act(self, s, h):
        """
        a function that returns the argmax of Q given the state and timestep
        """
        #print(np.array([self.Q[(h,s,a)] for a in range(self.env.nAction)]))
        return np.argmax(np.array([self.Q[(h,s,a)] for a in range(self.env.nAction)]))

    def proj(self, x, lo, hi):
        '''Projects the value of x into the [lo,hi] interval'''
        return max(min(x, hi), lo)

    def compute_Q(self, k):
        """
        a function that computes the Optimistic Q-values, see step 4 and Eq 5
        """
        Q = {(h, s, a): 0.0 for h in range(self.env.epLen) for s in self.env.states.keys() for a in range(self.env.nAction)}
        V = {h: np.zeros(self.env.nState) for h in range(self.env.epLen + 1)}
           
        for h in range(self.env.epLen-1, -1, -1):
            for s in self.env.states.keys():
                for a in range(self.env.nAction):
                    r = self.env.R[s,a][0]
                    P = np.dot(self.phi[(s,a)].T, self.mu[s])    
                    val = np.dot(P, V[h+1])
                    
                    Ainv = self.Ainv[s]
                    w_khi = np.sqrt(np.dot(np.dot(self.phi[(s,a)].T, Ainv), self.phi[(s,a)])) 
                    bonus = self.Beta(k)*w_khi
                                 
                    Q[h, s, a] = self.proj(r + val + bonus, 0, self.env.epLen)
                V[h][s] = max(np.array([self.Q[(h,s,a)] for a in range(self.env.nAction)]))
        self.Q = Q.copy()

    def Beta(self, k):
        return self.c*self.env.epLen*np.sqrt(self.d*1)*np.log(self.d*k*self.env.epLen)

    def update_matrix(self, s, a, r, ns):
        """
        a function that performs step 10 and 11
        """
        # gram matrix inverse: Sherman-Morrison Update
        self.Ainv[s] = self.Ainv[s] - np.dot((np.outer(np.dot(self.Ainv[s],self.phi[(s,a)]) ,self.phi[(s,a)])),self.Ainv[s]) / \
                    (1 + np.dot(np.dot(self.phi[(s,a)],self.Ainv[s]),self.phi[(s,a)]))
        # estimated matrix
        onehot_ns = np.zeros(self.env.nState)
        onehot_ns[ns] = 1
        self.sums[s] = self.sums[s] + np.outer(self.phi[(s,a)], onehot_ns)
        self.mu[s] = np.matmul(self.Ainv[s], self.sums[s])      

    def run(self): 
        print("UC_HRL (N=L)")
        episode_return = []
        
        for k in range(1,self.K+1):
                    
            self.env.reset()
            done = 0
            R = 0
                      
            while not done:
                s = self.env.state
                h = self.env.timestep
                a = self.act(s,h)                   
                r, s_, done = self.env.advance(a)
                
                R += r
                self.update_matrix(s, a, r, s_)
                
            episode_return.append(R)            
            self.compute_Q(k)
            
        return episode_return        