import torch
from torch.nn import functional as F


class SwiGLU(torch.nn.Module):

    def forward(self, x):

        x, gates = x.chunk(2, dim=-1)
        return F.silu(gates) * x
